<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

/**
 * Helper class for mod_yamaps
 */
class ModYaMapsHelper
{
    /**
     * Get markers from module parameters
     */
    public static function getMarkers($params)
    {
        $markers = $params->get('markers', []);
        $result = [];
        
        if (!empty($markers)) {
            foreach ($markers as $marker) {
                if (!empty($marker->lat) && !empty($marker->lon)) {
                    $result[] = [
                        'lat' => (float)$marker->lat,
                        'lon' => (float)$marker->lon,
                        'title' => $marker->title ?? '',
                        'description' => $marker->description ?? ''
                    ];
                }
            }
        }
        
        return $result;
    }
    
    /**
     * Calculate map center based on markers
     */
    public static function getMapCenter($markers)
    {
        if (empty($markers)) {
            return ['lat' => 55.751244, 'lon' => 37.618423]; // Москва по умолчанию
        }
        
        $latSum = 0;
        $lonSum = 0;
        $count = count($markers);
        
        foreach ($markers as $marker) {
            $latSum += $marker['lat'];
            $lonSum += $marker['lon'];
        }
        
        return [
            'lat' => $latSum / $count,
            'lon' => $lonSum / $count
        ];
    }
}