(function($) {
    'use strict';
    
    window.initYaMapsModule = function(mapId, options) {
        if (typeof ymaps === 'undefined') {
            console.error('Yandex Maps API not loaded');
            return;
        }
        
        ymaps.ready(function() {
            const mapElement = document.getElementById(mapId);
            if (!mapElement) return;
            
            const center = [parseFloat(mapElement.dataset.centerLat), parseFloat(mapElement.dataset.centerLon)];
            const zoom = parseInt(mapElement.dataset.zoom);
            const mapType = mapElement.dataset.mapType;
            const balloonImage = mapElement.dataset.balloonImage;
            
            const map = new ymaps.Map(mapId, {
                center: center,
                zoom: zoom,
                controls: ['zoomControl', 'typeSelector', 'fullscreenControl']
            });
            
            // Добавляем метки из данных
            const markersContainer = mapElement.nextElementSibling;
            if (markersContainer && markersContainer.classList.contains('yamaps-markers-data')) {
                const markersData = JSON.parse(markersContainer.textContent);
                
                markersData.forEach(function(marker) {
                    const placemark = new ymaps.Placemark(
                        [marker.lat, marker.lon],
                        {
                            balloonContentHeader: marker.title,
                            balloonContentBody: marker.description,
                            hintContent: marker.title
                        },
                        {
                            preset: 'islands#icon',
                            iconColor: '#0095b6'
                        }
                    );
                    
                    map.geoObjects.add(placemark);
                });
                
                // Автоцентрирование
                if (mapElement.dataset.autoCenter === '1' && markersData.length > 0) {
                    map.setBounds(map.geoObjects.getBounds(), {
                        checkZoomRange: true,
                        zoomMargin: 20
                    });
                }
            }
        });
    };
    
})(jQuery);