<?php
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

// Настройки карты
$apiKey = $params->get('apikey', '');
$zoom = $params->get('zoom', 10);
$map_height = $params->get('mapheight', 400);
$map_radius = $params->get('mapradius', 20);
$balloonImage = $params->get('balloonImage', '');
$mapType = $params->get('mapType', 'map');
$autoCenter = $params->get('autoCenter', 1);
$disable_zoom = $params->get('disableZoom', 0);
$icon_width = $params->get('iconwidth', 40);
$icon_height = $params->get('iconheight', 52);
$offset = $icon_width / 2;
if(empty($balloonImage)){
    $balloonImage = 'modules/mod_yamaps/media/img/location.png';
}
// Генерируем уникальный ID для карты
$mapId = 'yandex-map-' . $module->id;

// Подключаем скрипты и стили
if (!empty($apiKey)) {
    $document = Factory::getDocument();
    $document->addScript("https://api-maps.yandex.ru/2.1/?apikey={$apiKey}&lang=ru_RU");
    
    // Добавляем inline скрипт для инициализации карты
    $script = "
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof ymaps !== 'undefined') {
                ymaps.ready(initYaMap{$module->id});
            }
            
            function initYaMap{$module->id}() {
                const mapElement = document.getElementById('{$mapId}');
                const markersData = " . json_encode($markers) . ";
                
                const center = [" . $mapCenter['lat'] . ", " . $mapCenter['lon'] . "];
                const zoom = {$zoom};
                const mapType = '{$mapType}';
                const balloonImage = '" . ($balloonImage ? Uri::root() . $balloonImage : '') . "';
                
                // Создаем карту
                const map = new ymaps.Map('{$mapId}', {
                    center: center,
                    zoom: zoom,
                    controls: ['zoomControl', 'typeSelector', 'fullscreenControl']
                });
                
                // Добавляем метки
                if (markersData && markersData.length > 0) {
                    markersData.forEach(function(markerData) {
                        const marker = new ymaps.Placemark(
                            [markerData.lat, markerData.lon],
                            {
                                balloonContentHeader: markerData.title,
                                balloonContentBody: markerData.description,
                                hintContent: markerData.title
                            },
                            {
                                iconLayout: 'default#image',
                                iconImageHref: balloonImage || '',
                                iconImageSize: balloonImage ? [{$icon_width}, {$icon_height}] : [28, 40],
                                iconImageOffset: balloonImage ? [-{$offset}, -{$icon_height}] : [-14, -40]
                            }
                        );
                        
                        map.geoObjects.add(marker);
                        if({$disable_zoom}){
                            map.behaviors.disable('scrollZoom');
                        };
                        
                    });
                    
                    // Автоцентрирование
                    if ({$autoCenter}) {
                        map.setBounds(map.geoObjects.getBounds(), {
                            checkZoomRange: true,
                            zoomMargin: 100
                        });
                    }
                }
            }
        });
    "; 
    
    $document->addScriptDeclaration($script);
}
?>

<div class="mod-yamaps">
    <div id="<?php echo $mapId; ?>" class="yandex-map" style="width: 100%; height: <?=$map_height ?>px; overflow: hidden; border-radius: <?=$map_radius ?>px" ></div>
</div>