<?php
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;


class PlgSystemKeywordlinks extends CMSPlugin
{
    protected $autoloadLanguage = true;
    protected $app;
    
    public function __construct(&$subject, $config = array())
    {
        parent::__construct($subject, $config);
        $this->app = Factory::getApplication();
    }
    
    public function onContentPrepare($context, &$item, &$params, $page = 0)
    {
        // Работаем только во фронтенде
        if (!$this->app->isClient('site')) {
            return true;
        }

        // Получаем настройки плагина
        $keywords = $this->params->get('keywords', []);
        if (empty($keywords)) {
            return true;
        }

        // Подготавливаем массив для замены
        $replacements = [];
        foreach ($keywords as $keyword) {
            if (!empty($keyword->keyword) && !empty($keyword->link)) {
                $replacements[$keyword->keyword] = [
                    'link' => $keyword->link,
                    'title' => $keyword->title ?? $keyword->keyword,
                    'target' => $keyword->target ?? '_self'
                ];
            }
        }

        // Обрабатываем разные типы контента
        $this->processContent($context, $item, $replacements);

        return true;
    }

    protected function processContent($context, &$item, $replacements)
    {
        $maxReplacements = (int)$this->params->get('max_replacements', 100);
        $ignoreExistingLinks = (bool)$this->params->get('ignore_existing_links', 1);
        $addNoFollow = (bool)$this->params->get('add_nofollow', 0);
        $addClass = $this->params->get('link_class', 'keyword-link');


        // Для HTML-модулей
        if ($context === 'mod_custom.content') {
            //echo $context;
            //echo '<pre>';
            //print_r($item);
            //echo '</pre>';
            $item->text = $this->replaceKeywords(
                $item->text,
                $replacements,
                $maxReplacements,
                $ignoreExistingLinks,
                $addNoFollow,
                $addClass
            );
            return;
        }
        
        // Для категорий (description)
        if (($context === 'com_content.category' || $context === 'com_content.categories') && isset($item->description)) {
            $item->description = $this->replaceKeywords(
                $item->description,
                $replacements,
                $maxReplacements,
                $ignoreExistingLinks,
                $addNoFollow,
                $addClass
            );
        }

        // Для материалов
        if (strpos($context, 'com_content') === 0) {
            if (isset($item->text)) {
                $item->text = $this->replaceKeywords(
                    $item->text,
                    $replacements,
                    $maxReplacements,
                    $ignoreExistingLinks,
                    $addNoFollow,
                    $addClass
                );
            }
            
            if (isset($item->introtext)) {
                $item->introtext = $this->replaceKeywords(
                    $item->introtext,
                    $replacements,
                    $maxReplacements,
                    $ignoreExistingLinks,
                    $addNoFollow,
                    $addClass
                );
            }
        }
        
    }

    protected function replaceKeywords($text, $replacements, $maxReplacements, $ignoreExistingLinks, $addNoFollow, $addClass)
    {
        $count = 0;
        
        foreach ($replacements as $keyword => $data) {
            if ($count >= $maxReplacements) break;
            
            $pattern = '/\b(' . preg_quote($keyword, '/') . ')\b';
            
            if ($ignoreExistingLinks) {
                $pattern .= '(?![^<]*<\/a>)';
            }
            
            $pattern .= '/iu';
            
            $replacement = '<a href="' . $data['link'] . '"';
            $replacement .= ' title="' . htmlspecialchars($data['title'], ENT_QUOTES) . '"';
            $replacement .= ' target="' . $data['target'] . '"';
            
            if ($addClass) {
                $replacement .= ' class="' . $addClass . '"';
            }
            
            if ($addNoFollow) {
                $replacement .= ' rel="nofollow"';
            }
            
            $replacement .= '>$1</a>';
            
            $text = preg_replace($pattern, $replacement, $text, -1, $replaced);
            $count += $replaced;
        }
        
        return $text;
    }
}